<?php 

$done = false;
$error = false;

require_once('../lib/database.php');
require_once('../admincp/functions.php');

try {

    // Setup database connection
    $conn = new PDO("mysql:host=".$db_config['host'].";dbname=".$db_config['name'],$db_config['user'],$db_config['pass']);
    $conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);

}
catch(PDOException $e){
    $error = "connect";
}

// parse SQL, run only commands
$dump = file_get_contents('data.sql');
preg_match_all("/(?:^|\n)([A-Z][^;]+);/", $dump, $sql_data);

// Dump the data into database
foreach($sql_data[1] as $query)
{
    $conn->query($query);
}

// var_dump($sql_data);


// Get settings from database
$sql = $conn->query("SELECT * FROM config");
$config = $sql->fetch();

// change the keys for title and description
$config['title'] = $config['site_title'];
unset($config['site_title']);
$config['description'] = $config['site_description'];
unset($config['site_description']);


if(update_options($config))
{
    $done = 'config';
}
else
{
    $error = 'config';
}

$sql = $conn->query("SELECT * FROM pages WHERE id=1");
$sqldata = $sql->fetch();

$data = $sqldata['about'];
$sql = $conn->prepare("UPDATE content SET page_content=:data WHERE page_slug='about' ");
$sql->execute(array('data' => $data ));

$data = $sqldata['privacy'];
$sql = $conn->prepare("UPDATE content SET page_content=:data WHERE page_slug='privacy' ");
$sql->execute(array('data' => $data ));

$data = $sqldata['terms'];
$sql = $conn->prepare("UPDATE content SET page_content=:data WHERE page_slug='terms' ");
$sql->execute(array('data' => $data ));

$data = $sqldata['contact'];
$sql = $conn->prepare("UPDATE content SET page_content=:data WHERE page_slug='contact' ");
$sql->execute(array('data' => $data ));





?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Update - PingClan</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="HTML5 Admin Simplenso Template">
  <meta name="author" content="ahoekie">

  <!-- Stylesheets -->
  <link href="../admincp/assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="../admincp/assets/css/bootstrap-responsive.min.css" rel="stylesheet">
  <link href="../admincp/assets/css/style.css" rel="stylesheet">
  
  <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
  <!--[if lt IE 9]>
    <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
  <![endif]-->

</head>
<body>


<div class="container">
    <form class="form-horizontal span4 offset3" action="" method="POST">
        <fieldset>
            <div id="legend" class="page-header">
                <legend class="">PingClan Upade Complete</legend>
            </div>
            
                <p>Remove the update directory from your server and check the new admincp for changes.</p>

        </fieldset>
    </form>
</div>

  <!-- javascript Templates
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
    <script src="../admincp/assets/js/bootstrap.min.js"></script>

  </body>
</html>